<?php
session_start(); // Oturumu başlat

// Rastgele sayı sadece ilk defa oluşturulsun
if (!isset($_SESSION['hedefSayi'])) {
    $_SESSION['hedefSayi'] = rand(1, 100);
    $_SESSION['denemeSayisi'] = 0;
}

// Kullanıcı tahmin yaptıysa
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $tahmin = intval($_POST["tahmin"]);
    $_SESSION['denemeSayisi']++;

    if ($tahmin < $_SESSION['hedefSayi']) {
        $mesaj = "Daha büyük bir sayı girin!";
    } elseif ($tahmin > $_SESSION['hedefSayi']) {
        $mesaj = "Daha küçük bir sayı girin!";
    } else {
        $mesaj = "🎉 Tebrikler! Doğru tahmini yaptınız: {$_SESSION['hedefSayi']}<br>";
        $mesaj .= "Toplam deneme sayınız: {$_SESSION['denemeSayisi']}<br>";

        // Oyunu sıfırla (Yeni oyun için)
        session_destroy();
        session_start();
        $_SESSION['hedefSayi'] = rand(1, 100);
        $_SESSION['denemeSayisi'] = 0;
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tahmin Oyunu</title>
</head>
<body>
    <h2>1 ile 100 arasında bir sayı tahmin edin</h2>
    <form method="post">
        <input type="number" name="tahmin" min="1" max="100" required>
        <button type="submit">Tahmin Et</button>
    </form>

    <?php if (isset($mesaj)) echo "<p><strong>$mesaj</strong></p>"; ?>
</body>
</html>
